@extends("layouts.dashboard.app")

@section("page-nav-title")
    <div class="app-title">
        <div>
            <h1><i class="fa fa-dashboard"></i>craete Contry Code</h1>
    
        </div>
        <ul class="app-breadcrumb breadcrumb">
            <li class="breadcrumb-item"><i class="fa fa-home fa-lg"></i></li>
            <li class="breadcrumb-item"><a href="{{route("CountryCode.index")}}">Contry Code</a></li>
            <li class="breadcrumb-item"><a href="#">Create</a></li>
        </ul>
    </div>
@endsection
@section("content")
    <div class="row">
        <div class="col-lg-10 m-auto">
            <div class="tile">
                <h3 class="tile-title">Create Contry Code</h3>
                <div class="tile-body">
                    

                    
                    <form method="post" action="{{route("CountryCode.store")}}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="control-label">Contry Code</label>

                                    <select id="country" name="contryCode" class="form-control">
                                            <option value="" >select country</option>
                                            @foreach($CountryDataSelect as $CountryData)
                                                     <option value="{{$CountryData->CountryCode}}">{{$CountryData->ContryName}}</option>
                                            @endforeach
                                     
                                    </select>


                                </div>
                                @error("contryCode")
                                <div class="input-error">{{$message}}</div>
                                @enderror
                            </div>
 
                    
   
                            
                           
                        </div>

                   
                   
               

                        <div class="tile-footer">
                            <button class="btn btn-primary" type="submit"><i class="fa fa-fw fa-lg fa-check-circle"></i>Create</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
@endsection
@section("scripts")

<div id="selected_country"></div>

<script>
$(function () {
    $("#country").change(function() {
        var val = $(this).val();
        var text = $("#country option:selected").text();
        $("#selected_country").html(val + '<br>' + text);
    });
});
</script>
@endscript
