<?php

namespace App\Services\HyperPay;


class PaymentResponse
{
    protected $status;
    protected $checkoutId;
    protected $paymentType;
    protected $statusResult;
    protected $redirectResult;

    public function __construct(\Psr\Http\Message\StreamInterface $response)
    {
        $response = json_decode($response);
        $this->status = in_array($response->result->code, ['000.000.000', '000.100.110', '000.100.111', '000.100.112', '000.200.000']);
        $this->checkoutId = $response->id;
        $this->paymentType = $response->paymentBrand;
        $this->statusResult = $response->result;
        $this->redirectResult = $response->redirect;
    }

    /**
     * @return bool
     */
    public function getStatus(): bool
    {
        return $this->status;
    }

    /**
     * @return mixed
     */
    public function getCheckoutId()
    {
        return $this->checkoutId;
    }

    /**
     * @return mixed
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }

    /**
     * @return mixed
     */
    public function getStatusResult()
    {
        return $this->statusResult;
    }

    /**
     * @return mixed
     */
    public function getRedirectResult()
    {
        return $this->redirectResult;
    }

}
