<?php

namespace App\Services\HyperPay;

use GuzzleHttp\Client;

class PaymentRequest
{
    protected $client;
    protected $data;
    protected $response;
    protected $paymentMethod;
    protected $entityId;
    protected $authorizationToken;
    protected $url;
    public function __construct(Payment $paymentMethod){
        $this->client = new Client();
        $this->paymentMethod = $paymentMethod;
        $this->entityId = env("HYPER_PAY_ENTITY_ID");
        $this->authorizationToken = "Bearer " . env("HYPER_PAY_AUTHORIZATION_TOKEN");
    }


    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function pay(): PaymentResponse
    {

        $url = env("HYPER_PAY_URL") . env("HYPER_PAY_URI");
        $data =  $this->getData();
//        dd($data, $this->authorizationToken);
        $response = $this->client->request("POST", $url, ["query" => $data, "headers" => [  "Authorization" => $this->authorizationToken]]);
        $response = new PaymentResponse($response->getBody());
        return $response;
    }

    protected function getData(): string
    {
//        $data = $this->paymentMethod->getData();
//        $data["entityId"] = $this->entityId;
        $data = "entityId={$this->entityId}";
        foreach ($this->paymentMethod->getData() as $key => $value)
            $data .= "&$key=$value";

        return ($data);
    }


}
