<?php

namespace App\Services\HyperPay\PaymentMethods;

use App\Services\HyperPay\Payment;

class Visa extends Payment
{

    public function __construct()
    {
        parent::__construct('VISA', 'DB');
    }

    /**
     * @param mixed $cardNumber
     */
    public function cardNumber($cardNumber): self
    {
        $this->data["card.number"] = (int)$cardNumber;
        return $this;
    }


    /**
     * @param mixed $cardHolderName
     */
    public function cardHolderName($cardHolderName): self
    {
        $this->data["card.holder"] = (string)$cardHolderName;
        return $this;
    }

    /**
     * @param mixed $cardExpiryMonth
     * @param mixed $cardExpiryYear
     */
    public function cardExpiryDate($cardExpiryMonth, $cardExpiryYear): self
    {
        $this->data["card.expiryMonth"] = (string)$cardExpiryMonth;
        $this->data["card.expiryYear"] = (string)$cardExpiryYear;

        return $this;
    }

    /**
     * @param mixed $cardCVV
     */
    public function cardCVV($cardCVV): self
    {
        $this->data["card.cvv"] = (int)$cardCVV;
        return $this;
    }

}
