<?php

namespace App\Services\HyperPay\PaymentMethods;

use App\Services\HyperPay\Payment;

class MasterCard extends Payment
{
    public function __construct()
    {
        parent::__construct('MASTER', 'PA');
    }

    /**
     * @param mixed $cardNumber
     */
    public function cardNumber($cardNumber): MasterCard
    {
        $this->data["card.number"] = $cardNumber;
        return $this;
    }


    /**
     * @param mixed $cardHolderName
     */
    public function cardHolderName($cardHolderName): MasterCard
    {
        $this->data["card.holder"] = $cardHolderName;
        return $this;
    }

    /**
     * @param mixed $cardExpiryMonth
     * @param mixed $cardExpiryYear
     */
    public function cardExpiryDate($cardExpiryMonth, $cardExpiryYear): MasterCard
    {
        $this->data["card.expiryMonth"] = $cardExpiryMonth;
        $this->data["card.expiryYear"] = $cardExpiryYear;

        return $this;
    }

    /**
     * @param mixed $cardCVV
     */
    public function cardCVV($cardCVV): MasterCard
    {
        $this->data["card.cvv"] = $cardCVV;
        return $this;
    }



}
