<?php

namespace App\Services\HyperPay;

abstract class   Payment
{
    protected $data;

    public function __construct($paymentBrand, $paymentType){
        $this->data["paymentBrand"] = $paymentBrand;
        $this->data["paymentType"] = $paymentType;
        $this->data["currency"] = "SAR";
        $this->data["shopperResultUrl"] = "https://dashoard.nosdarzan.digisolapps.com/api/orders/online-payment/success";
    }

    /**
     * @param mixed $amount
     */
    public function amount($amount): Payment
    {
        $this->data["amount"] = (double)$amount;
        return $this;
    }



    public function getData(){
        return $this->data;
    }



}
